// Infopage.cpp : implementation file
//

#include "stdafx.h"
#include "DTC_C++Demo.h"
#include "MainSheet.h"
#include "UtilsPage.h"
#include <winspool.h>
#include <vector>
#include <string>

//#############################################################################

// CInfoPage dialog
IMPLEMENT_DYNAMIC(CUtilsPage, CPropertyPage)

CUtilsPage::CUtilsPage() : CPropertyPage(CUtilsPage::IDD)
{
}

CUtilsPage::~CUtilsPage()
{
}

void CUtilsPage::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_UTILSMSG, UtilsMessage);
	DDX_Control(pDX, IDC_APDUMSG, APDUCommandBox);
}

BEGIN_MESSAGE_MAP(CUtilsPage, CPropertyPage)
	ON_BN_CLICKED(IDC_BTN_UTILSMSG_CLR, &CUtilsPage::OnBnClickedBtnUtilsmsgClr)
	ON_BN_CLICKED(IDC_BTN_ENABLELOGGING, &CUtilsPage::OnBnClickedBtnEnableLogging)
	ON_BN_CLICKED(IDC_BTN_DISABLELOGGING, &CUtilsPage::OnBnClickedBtnDisableLogging)
	ON_BN_CLICKED(IDC_BTN_SENDAPDU, &CUtilsPage::onBnClickedBtnSendAPDU)
END_MESSAGE_MAP()

//#############################################################################

// CInfoPage message handlers
BOOL CUtilsPage::OnInitDialog()
{
	CPropertyPage::OnInitDialog();

	Parent = (CMainSheet *)GetParent();

	return TRUE;  // return TRUE  unless you set the focus to a control
}

//****************************************************************************

void CUtilsPage::OnBnClickedBtnUtilsmsgClr()
{
	UtilsMessage.SetWindowText(_T(""));
}

//****************************************************************************

void CUtilsPage::AddUtilsMessage(CString pMessage)
{
	Parent->AddString(&UtilsMessage, pMessage);
}

//****************************************************************************

void CUtilsPage::onBnClickedBtnSendAPDU()
{
	PFNIDSENDAPDU pFnSendAPDU = (PFNIDSENDAPDU)GetProcAddress(Parent->hLib, "ID_SendAPDU");
	if (!pFnSendAPDU)
	{
		FUNCTION_NOT_ACCESSED(SendAPDU);
	}
	else
	{
		//Call SDK to send APDU
		CString apduString;
		int size = 0;
		APDUCommandBox.GetWindowText(apduString);
		if (apduString.GetLength() != 0)
		{
			LPWSTR apduReturn = new wchar_t[512];

			CStringA pInputAPDU(apduString);

			auto nLineCount = APDUCommandBox.GetLineCount();

			for (int i=0; i < nLineCount; i++) 
			{
				int len = APDUCommandBox.LineLength(APDUCommandBox.LineIndex(i));
				CString apduString;
				APDUCommandBox.GetLine(i, apduString.GetBuffer(len), len);
				apduString.ReleaseBuffer(len);
				CStringA apduStringA = apduString;
				char* inputAPDUConverted = (char*)(LPCSTR)apduStringA;
				char tmp[512];
				char* ptmp = tmp;

				AddUtilsMessage(_T("APDU Sent") + Parent->Separator(ID_WRITE) + apduString);
				AddUtilsMessage(_T(""));
				ID_RETURN SDKReturn = (*pFnSendAPDU)(Parent->hSession,inputAPDUConverted, ptmp, &size);
				std::vector<char> data(ptmp, ptmp + size);
				CString str;
				for (int i=0; i < data.size(); ++i) {
					str+=data[i];
				}
			
				if (SDKReturn != ID_SUCCESS)
				{
					DISPLAY_ERROR(SendAPDU, SDKReturn);
				}
				else 
				{
					AddUtilsMessage(_T("APDU Reply") + Parent->Separator(ID_READ) + str);
					AddUtilsMessage(_T(""));
				}
				//Sleep(300);
			}
		}
	}
}

//****************************************************************************

void CUtilsPage::OnBnClickedBtnEnableLogging()
{
	PFNIDCONTROL pFnControl = (PFNIDCONTROL)GetProcAddress(Parent->hLib, "ID_Control");
	if (!pFnControl)
	{
		FUNCTION_NOT_ACCESSED(MoveCard);
	}

	else
	{
		ID_CONTROL control;
		ID_RETURN SDKReturn = (*pFnControl)(Parent->hSession, ID_READ, &control);
		if (SDKReturn != ID_SUCCESS)
		{
			DISPLAY_ERROR(EnableLoggingRead, SDKReturn);
		}

		if ((control & ID_LOGGING) == 0)
		{
			control = (ID_CONTROL)(control + ID_LOGGING);
			SDKReturn = (*pFnControl)(Parent->hSession, ID_WRITE, &control);
			if (SDKReturn != ID_SUCCESS)
			{
				DISPLAY_ERROR(EnableLoggingWrite, SDKReturn);
			}
			else
			{
				AddUtilsMessage(_T("SDK Logging: ENABLED"));
				AddUtilsMessage(_T(""));
			}
		}
	}
}

//****************************************************************************

void CUtilsPage::OnBnClickedBtnDisableLogging()
{
	PFNIDCONTROL pFnControl = (PFNIDCONTROL)GetProcAddress(Parent->hLib, "ID_Control");
	if (!pFnControl)
	{
		FUNCTION_NOT_ACCESSED(MoveCard);
	}

	else
	{
		ID_CONTROL control;
		ID_RETURN SDKReturn = (*pFnControl)(Parent->hSession, ID_READ, &control);
		if (SDKReturn != ID_SUCCESS)
		{
			DISPLAY_ERROR(DisableLoggingRead, SDKReturn);
		}

		if ((control & ID_LOGGING) != 0)
		{
			control = (ID_CONTROL)(control & ~ID_LOGGING);
			SDKReturn = (*pFnControl)(Parent->hSession, ID_WRITE, &control);
			if (SDKReturn != ID_SUCCESS)
			{
				DISPLAY_ERROR(DisableLoggingWrite, SDKReturn);
			}
			else
			{
				AddUtilsMessage(_T("SDK Logging: DISABLED"));
				AddUtilsMessage(_T(""));
			}
		}
	}
}
